VERSION 2.00
Begin Form frmLog 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Log"
   ClientHeight    =   2145
   ClientLeft      =   45
   ClientTop       =   345
   ClientWidth     =   6330
   Height          =   2550
   Left            =   -15
   ScaleHeight     =   2145
   ScaleWidth      =   6330
   Top             =   0
   Width           =   6450
   Begin ListBox lstEvents 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1980
      Left            =   60
      TabIndex        =   0
      Top             =   90
      Width           =   6165
   End
   Begin FMSG fmsg1 
      frmName         =   "log"
      IsClient        =   0   'False
      Left            =   0
      Top             =   0
   End
End
'================================================================================
'
'   log.frm
'
'   This is a simple log object that uses the FMSG.VBX custom control
'
'================================================================================
'Change History:
'
    Const cVersion = "961023"

'   Date    who     Description
'   ======= ======= ===============================
'
'================================================================================
'NOTES:
'
'================================================================================
'Turn on my favorite options:

    Option Explicit
    Option Base 1

'================================================================================
'Local variables:

    Dim indentLevel As Integer

Sub evtAdd (toAddRaw As String)

    Dim toAdd As String

    On Error Resume Next

    If lstEvents.ListCount > 400 Then       'purge items from top, if needed
        lstEvents.RemoveItem 0
    End If

    'NOTE:  you could just use a SendMessage to set the tabs, and then string$(indentLevel,chr$(9))'s:
    toAdd = Time$ & ":" & strRepeat(indentLevel, String$(5, 32)) & toAddRaw
    
    lstEvents.AddItem toAdd
    lstEvents.ListIndex = lstEvents.ListCount - 1

End Sub

Sub fmsg1_Exec (hBuff As Integer, IsDone As Integer)

    On Error Resume Next
    Err = 0

    Select Case fVerb(hBuff)
        Case "ADD"
            evtAdd fIn1(hBuff)
        
        Case "PUSH"
            evtAdd "Call " & fIn1(hBuff)
            evtAdd "---->"
            indentLevel = indentLevel + 1
            
        Case "POP"
            If indentLevel > 0 Then
                indentLevel = indentLevel - 1
                evtAdd "<----"
            Else
                evtAdd "POP ERROR!"
            End If

        Case "CLR", "CLEAR"
            lstEvents.Clear
        
        Case "SAVE"
            meSave fIn1(hBuff)

        Case "LOAD"
            meLoad fIn1(hBuff)

        Case "PAUSE"
            MsgBox "Press ENTER to continue."
        
        Case "BEEP"
            Beep
        
        Case Else
            fmsgExecDefault Me, fmsg1, hBuff
    End Select
    
    fmsgErrCk hBuff

End Sub

Sub Form_Resize ()

    On Error Resume Next
    
    If Me.WindowState <> 1 Then
        lstEvents.Move 5, 5, Me.ScaleWidth - 10, Me.ScaleHeight - 10
    End If

End Sub

Sub lstEvents_KeyDown (KeyCode As Integer, Shift As Integer)
    
    Dim tt As Integer
    Dim found As Integer

    If KeyCode = gcKeyCodeF4 Then
        found = False
        If Shift Then
            For tt = lstEvents.ListIndex - 1 To 0 Step -1
                If InStr(UCase$(lstEvents.List(tt)), "ERROR") <> 0 Then
                    lstEvents.ListIndex = tt
                    found = True
                    Exit For
                End If
            Next tt
        Else
            For tt = lstEvents.ListIndex + 1 To lstEvents.ListCount - 1
                If InStr(UCase$(lstEvents.List(tt)), "ERROR") <> 0 Then
                    lstEvents.ListIndex = tt
                    found = True
                    Exit For
                End If
            Next tt
        End If
        If Not found Then
            Beep
        End If
    End If

End Sub

Sub meLoad (fnameDefault As String)

    Dim fname As String
    Dim ff As Integer
    Dim aa As String

    On Error Resume Next
    
    If Len(fnameDefault) Then
        fname = fnameDefault
    Else
        fname = InputBox("Enter the name of the file", "LOAD LOG", "C:\SAVED.LOG")
    End If

    If Len(fname) Then
        ff = FreeFile
        Err = 0
        Open fname For Input As #ff
        If Err Then
            MsgBox Error$(Err) & " occurred while trying to load.  Load not performed."
            Exit Sub
        Else
            While Not EOF(ff)
                Line Input #ff, aa
                evtAdd aa
            Wend
            Close #ff
        End If
    End If

End Sub

Sub meSave (fnameDefault As String)

    Dim fname As String
    Dim ff As Integer
    Dim tt As Integer

    On Error Resume Next
    
    If Len(fnameDefault) Then
        fname = fnameDefault
    Else
        fname = InputBox("Enter the name of the file", "SAVE LOG", "C:\SAVED.LOG")
    End If

    If Len(fname) Then
        ff = FreeFile
        Err = 0
        Open fname For Output As #ff
        If Err Then
            MsgBox Error$(Err) & " occurred while trying to save.  Save not performed."
            Exit Sub
        Else
            For tt = 0 To lstEvents.ListCount - 1
                Print #ff, lstEvents.List(tt)
            Next tt
            Close #ff
        End If
    End If

End Sub

